<?php
// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Security headers
header('X-Frame-Options: DENY');
header('X-Content-Type-Options: nosniff');
header('X-XSS-Protection: 1; mode=block');

$action = $_GET['action'] ?? '';

if ($action === 'logout') {
    // Log logout activity
    if (isset($_SESSION['user_email'])) {
        error_log("User logout: {$_SESSION['user_email']}");
    }
    
    // Store user info for success message
    $user_name = $_SESSION['user_name'] ?? 'User';
    
    // Store success message in session before destroying
    $_SESSION['logout_success'] = "You have been successfully logged out. Goodbye, {$user_name}!";
    
    // Clear all session variables
    $_SESSION = array();
    
    // Destroy the session cookie
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    
    // Destroy the session
    session_destroy();
    
    // Redirect to login page with success message
    header('Location: /daily_task/index.php');
    exit;
}

// If someone accesses this file directly without action, redirect to login
header('Location: /daily_task/index.php');
exit;
?>