<?php
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

$current_page = basename($_SERVER['PHP_SELF']);
$user_role = $_SESSION['user_role'];
$user_name = $_SESSION['user_name'];
?>

<aside class="sidebar">
    <div class="sidebar-header">
        <div class="logo-container">
            <div class="logo-icon">🗓️</div>
            <div class="logo-text">
                <h3>Task Manager</h3>
                <small>Management System</small>
            </div>
        </div>
        <div class="user-info-sidebar">
            <div class="user-avatar-sidebar">
                <?php echo strtoupper(substr($user_name, 0, 1)); ?>
            </div>
            <div class="user-details">
                <div class="user-name"><?php echo htmlspecialchars($user_name); ?></div>
                <div class="user-role"><?php echo ucfirst($user_role); ?></div>
            </div>
        </div>
    </div>
    
    <nav class="sidebar-nav">
        <?php if ($user_role === 'admin'): ?>
            <a href="index.php" class="nav-item <?php echo $current_page == 'index.php' ? 'active' : ''; ?>">
                <span class="nav-icon">📊</span>
                <span class="nav-text">Dashboard</span>
            </a>
            <a href="tasks.php" class="nav-item <?php echo $current_page == 'tasks.php' ? 'active' : ''; ?>">
                <span class="nav-icon">✅</span>
                <span class="nav-text">Manage Tasks</span>
                <?php
                $pending_count = getPendingApprovalCount();
                if ($pending_count > 0): ?>
                    <span class="nav-badge"><?php echo $pending_count; ?></span>
                <?php endif; ?>
            </a>
            <a href="users.php" class="nav-item <?php echo $current_page == 'users.php' ? 'active' : ''; ?>">
                <span class="nav-icon">👥</span>
                <span class="nav-text">Manage Users</span>
            </a>
            <a href="reports.php" class="nav-item <?php echo $current_page == 'reports.php' ? 'active' : ''; ?>">
                <span class="nav-icon">📈</span>
                <span class="nav-text">Reports</span>
            </a>
        <?php else: ?>
            <a href="index.php" class="nav-item <?php echo $current_page == 'index.php' ? 'active' : ''; ?>">
                <span class="nav-icon">📊</span>
                <span class="nav-text">Dashboard</span>
            </a>
            <a href="my-tasks.php" class="nav-item <?php echo $current_page == 'my-tasks.php' ? 'active' : ''; ?>">
                <span class="nav-icon">✅</span>
                <span class="nav-text">My Tasks</span>
            </a>
            <a href="submit-task.php" class="nav-item <?php echo $current_page == 'submit-task.php' ? 'active' : ''; ?>">
                <span class="nav-icon">➕</span>
                <span class="nav-text">Submit Task</span>
            </a>
        <?php endif; ?>
        
        <div class="nav-divider"></div>
        
        <a href="../../api/auth.php?action=logout" class="nav-item logout-item">
            <span class="nav-icon">🚪</span>
            <span class="nav-text">Logout</span>
        </a>
    </nav>
</aside>

<style>
.sidebar {
    width: 280px;
    background: var(--bg-secondary);
    border-right: 1px solid var(--border);
    padding: 0;
    position: fixed;
    height: 100vh;
    overflow-y: auto;
    transition: all 0.3s ease;
}

.sidebar-header {
    padding: 1.5rem;
    border-bottom: 1px solid var(--border);
    background: var(--bg-tertiary);
}

.logo-container {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin-bottom: 1.5rem;
}

.logo-icon {
    font-size: 2rem;
}

.logo-text h3 {
    margin: 0;
    background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    font-size: 1.25rem;
}

.logo-text small {
    color: var(--text-muted);
    font-size: 0.75rem;
}

.user-info-sidebar {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.user-avatar-sidebar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    color: white;
    font-size: 1rem;
}

.user-details {
    flex: 1;
}

.user-name {
    font-weight: 600;
    color: var(--text-primary);
    font-size: 0.9rem;
}

.user-role {
    color: var(--text-muted);
    font-size: 0.8rem;
}

.sidebar-nav {
    display: flex;
    flex-direction: column;
    padding: 1rem 0;
}

.nav-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.875rem 1.5rem;
    color: var(--text-secondary);
    text-decoration: none;
    transition: all 0.3s ease;
    border-left: 3px solid transparent;
    position: relative;
}

.nav-item:hover {
    background: var(--bg-tertiary);
    color: var(--text-primary);
    border-left-color: var(--border-light);
}

.nav-item.active {
    background: var(--bg-tertiary);
    color: var(--primary);
    border-left-color: var(--primary);
    font-weight: 600;
}

.nav-icon {
    width: 20px;
    text-align: center;
    font-size: 1.1rem;
}

.nav-text {
    flex: 1;
    font-size: 0.9rem;
}

.nav-badge {
    background: var(--danger);
    color: white;
    padding: 0.2rem 0.5rem;
    border-radius: 10px;
    font-size: 0.7rem;
    font-weight: 600;
    min-width: 20px;
    text-align: center;
}

.nav-divider {
    height: 1px;
    background: var(--border);
    margin: 0.5rem 1.5rem;
}

.logout-item {
    margin-top: auto;
    color: var(--danger);
}

.logout-item:hover {
    color: var(--danger);
    border-left-color: var(--danger);
}

@media (max-width: 768px) {
    .sidebar {
        width: 100%;
        height: auto;
        position: relative;
        transform: translateX(-100%);
    }
    
    .sidebar.mobile-open {
        transform: translateX(0);
    }
}
</style>

<?php
function getPendingApprovalCount() {
    if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
        return 0;
    }
    
    try {
        include_once '../../config/database.php';
        include_once '../../models/Task.php';
        
        $database = new Database();
        $db = $database->getConnection();
        $task = new Task($db);
        
        return $task->getPendingApprovalCount();
    } catch (Exception $e) {
        error_log("Error getting pending count: " . $e->getMessage());
        return 0;
    }
}
?>